
#################
# Mob Particles #
#################
execute at @e[name="Mechapod Prime"] run particle minecraft:flame ~ ~ ~ 0 0 0 0.05 1 normal
execute at @e[name="Reanimated Bones"] run particle minecraft:enchant ~ ~1.7 ~ 0 0 0 0.5 1 normal

################
#  Mob Sounds  #
################
execute at @e[name="Sol Corp Security",nbt={HurtTime:10s}] run playsound minecraft:block.glass.break hostile @a ~ ~ ~ 0.6 0.2 0
execute at @e[name="Lunatic Acolyte",nbt={HurtTime:10s}] run playsound minecraft:entity.enderman.hurt hostile @a ~ ~ ~ 0.6 0.5 0
execute at @e[name="Lunatic Priest",nbt={HurtTime:10s}] run playsound minecraft:entity.enderman.hurt hostile @a ~ ~ ~ 0.6 0.5 0
execute at @e[name="Reanimated Bones",nbt={HurtTime:10s}] run playsound minecraft:entity.skeleton.hurt hostile @a ~ ~ ~ 0.3 0.5 0
execute at @e[name="Rocket Scientist",nbt={HurtTime:10s}] run playsound minecraft:entity.phantom.hurt hostile @a ~ ~ ~ 1 0.8 0
execute at @e[name="Lingering Hatred",nbt={HurtTime:10s}] run playsound minecraft:entity.phantom.hurt hostile @a ~ ~ ~ 1 0.5 0
execute at @e[name="Bad Memories",nbt={HurtTime:10s}] run playsound minecraft:entity.phantom.hurt hostile @a ~ ~ ~ 1 0.5 0
execute at @e[name="Office Drone",nbt={HurtTime:10s}] run playsound minecraft:entity.iron_golem.hurt hostile @a ~ ~ ~ 1 1 0
execute at @e[name="Rusty Outlaw",nbt={HurtTime:10s}] run playsound minecraft:entity.iron_golem.hurt hostile @a ~ ~ ~ 1 1 0
execute at @e[name="Crumbling Golem",nbt={HurtTime:10s}] run playsound minecraft:entity.shulker.hurt hostile @a ~ ~ ~ 0.6 0.5 0

#################
# Mob Behaviors #
#################

# For mobs that have a special death effect, keep track of their health in a scoreboard value
execute as @e[tag=deathEffect] store result score @s mobHealth run data get entity @s Health 1

# Lunatic teleportation
execute as @e[name="Boss",type=drowned,scores={mobHealth=..100}] run tag @s remove Lunatic
scoreboard players set @e[tag=Lunatic,nbt={HurtTime:10s}] vanishTime 30
scoreboard players remove @e[scores={vanishTime=1..30}] vanishTime 1
execute at @e[scores={vanishTime=29}] run summon minecraft:bat ~ ~ ~ {Silent:1,Invulnerable:1,Attributes:[{Name:generic.movementSpeed,Base:10}],ActiveEffects:[{Id:14b,Amplifier:1b,Duration:9999,ShowParticles:0b}]}
execute at @e[scores={vanishTime=29}] run particle minecraft:enchanted_hit ~ ~ ~ 0 1 0 0.4 20 force
execute as @e[scores={vanishTime=29}] at @s run data merge entity @s {NoAI:1,Invulnerable:1}
execute as @e[scores={vanishTime=28}] at @s run tp @s ~ ~50 ~
execute as @e[scores={vanishTime=10}] at @s run tp @s @e[type=bat,sort=nearest,limit=1]
execute as @e[scores={vanishTime=10}] at @s run tp @e[type=bat,sort=nearest,limit=1] ~ ~-1000 ~
execute as @e[scores={vanishTime=7..9}] at @s run data merge entity @s {NoAI:0}
execute as @e[scores={vanishTime=5}] at @s run data merge entity @s {Invulnerable:0}
execute at @e[scores={vanishTime=6..10}] run particle minecraft:enchanted_hit ~ ~ ~ 0 1 0 0.4 10 force
execute at @e[scores={vanishTime=5}] run playsound minecraft:entity.iron_golem.step hostile @a ~ ~ ~ 1 1 1
execute at @e[type=bat] run particle minecraft:totem_of_undying ~ ~1 ~ 0 0 0 0 1 force

# Explosive critic tnt drop
execute at @e[name="Explosive Critic",scores={mobHealth=..10}] run summon tnt ~ ~ ~ {Fuse:30s,Tags:["safe"]}
kill @e[name="Explosive Critic",scores={mobHealth=..10}]
execute at @e[type=minecraft:tnt,tag=safe,nbt={Fuse:1s}] run summon creeper ~ ~ ~ {Fuse:0,CustomName:"{\"text\":\"Explosive Critic\",\"color\":\"aqua\"}"}
kill @e[type=tnt,tag=safe,nbt={Fuse:1s}]
execute as @e[name="Explosive Critic",nbt={CustomNameVisible:1b}] run data merge entity @s {CustomNameVisible:0b}

# Lingering hatred glow toggle & death
execute as @e[name="Lingering Hatred"] at @s unless entity @a[distance=..20] run data merge entity @s {Glowing:0b}
execute as @e[name="Lingering Hatred"] at @s if entity @a[distance=..20] run data merge entity @s {Glowing:1b}
tag @e[name="Lingering Hatred"] add deathEffect
kill @e[name="Lingering Hatred",scores={mobHealth=..15}]

# Bad memories glow toggle
execute as @e[name="Bad Memories"] at @s unless entity @a[distance=..20] run data merge entity @s {Glowing:0b}
execute as @e[name="Bad Memories"] at @s if entity @a[distance=..20] run data merge entity @s {Glowing:1b}

# Rocket scientist firework
execute at @e[name="Rocket Scientist",scores={mobHealth=..10}] run summon firework_rocket ~ ~1 ~ {LifeTime:15,FireworksItem:{id:firework_rocket,Count:1,tag:{Fireworks:{Flight:1,Explosions:[{Type:2,Flicker:0,Trail:1,Colors:[I;11743532],FadeColors:[I;15790320]}]}}}}
kill @e[name="Rocket Scientist",scores={mobHealth=..10}]

# Crumbling golem silverfish
execute at @e[tag=Golem,nbt={HurtTime:10s}] run summon silverfish ~ ~ ~ {Health:1f,CustomName:"{\"text\":\"Synthetic Swarmer\",\"color\":\"aqua\"}",Attributes:[{Name:generic.maxHealth,Base:1},{Name:generic.movementSpeed,Base:0.17}]}

# Head initialization
execute as @e[name="Sol Corp Security",tag=!init] run function t:entity/init/security
execute as @e[name="Office Drone",tag=!init] run function t:entity/init/drone
execute as @e[name="Rocket Scientist",tag=!init] run function t:entity/init/scientist
execute as @e[name="Reanimated Bones",tag=!init] run function t:entity/init/bones
execute as @e[name="Lunatic Acolyte",tag=!init] run function t:entity/init/acolyte
execute as @e[name="Lunatic Priest",tag=!init] run function t:entity/init/priest
execute as @e[name="Explosive Critic",tag=!init] run function t:entity/init/critic
execute as @e[name="Rusty Outlaw",tag=!init] run function t:entity/init/outlaw
execute as @e[name="Crumbling Golem",tag=!init] run function t:entity/init/golem
execute as @e[name="Avant Guard",tag=!init] run function t:entity/init/guard
execute as @e[name="Ancient War Drone",tag=!init] run function t:entity/init/wardrone
execute as @e[name="Ancient Defender",tag=!init] run function t:entity/init/defender